import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import camping1 from '/images/camping-1.jpg'
import camping2 from '/images/camping-2.jpg'
import camping3 from '/images/camping-3.jpg'
import camping4 from '/images/camping-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: camping1,
      title: 'Природа'
    },
    {
      id: 2,
      src: camping2,
      title: 'Приключения'
    },
    {
      id: 3,
      src: camping3,
      title: 'Кемпинг'
    },
    {
      id: 4,
      src: camping4,
      title: 'Отдых'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-outdoor">
      <div className="slider-wrapper-outdoor">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-outdoor ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-outdoor" />
            <div className="slide-overlay-outdoor"></div>
            <div className="slide-content-outdoor">
              <h3 className="slide-title-outdoor">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-outdoor prev-outdoor" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-outdoor" size={24} />
      </button>
      <button className="slider-btn-outdoor next-outdoor" onClick={goToNext}>
        <ChevronRight className="slider-icon-outdoor" size={24} />
      </button>
      <div className="slider-dots-outdoor">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-outdoor ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

